
--- #21558
-- Funktion ruft Feiertage und Ferien von der openholidays API ab
CREATE OR REPLACE FUNCTION x_10_interfaces.openholidaysapi__Feiertage_Schulferien_get(
      IN _typ                  integer,                                                                   -- 0 - Feiertage, 1 - Schulferien
      IN _land                 varchar,
      IN _bundesland           varchar,
      IN _datum_von            date DEFAULT DATE_TRUNC('year', CURRENT_DATE),                             -- Standard ist 01.01. des aktuellen Jahres
      IN _datum_bis            date DEFAULT DATE_TRUNC('year', CURRENT_DATE) + INTERVAL '1 year - 1 day', -- Standard ist 31.12. des aktuellen Jahres

      OUT status               integer,
      OUT content_type         varchar,
      OUT content              varchar
    ) RETURNS record AS $$
 DECLARE
          _url                 varchar;
          _content             jsonb := null;
          _event               jsonb;
          _ft_name_v           varchar;
          _ft_endDate_v        date;
          _ft_startDate_v      date;
          i                    integer := 0;
 BEGIN

    -- Prüfen ob Eingangsparameter korrekt gesetzt sind
    IF NOT _typ IN (0,1)
        OR _land IS NULL THEN
      raise exception 'Falscher Eingangsparameter';
    END IF;

    -- URL zusammenbauen um Events von API abzurufen
    _url := concat( 'https://openholidaysapi.org/',
                    CASE _typ
                      WHEN 0 THEN 'PublicHolidays'
                      WHEN 1 THEN 'SchoolHolidays'
                    END,
                    '?countryIsoCode=',   trim( _land ),
                    '&languageIsoCode=',  trim( _land ),
                    '&validFrom=',        trim( _datum_von ),
                    '&validTo=',          trim( _datum_bis ),
                    CASE WHEN _bundesland IS NOT NULL THEN
                      '&subdivisionCode=' || trim( _bundesland )
                    END
                  );

    -- gesonderter Block für Exception Handling
    BEGIN
      status := 0;
      SELECT
        h.content::jsonb,
        h.status,
        h.content_type,
        h.content
      INTO _content, status, content_type, content
      FROM tsystem.http_get_request( _url ) AS h;

      raise notice '*********************************************';
    EXCEPTION
        WHEN OTHERS THEN
            RAISE WARNING 'x_10_interfaces.openholidaysapi__Feiertage_Schulferien_get ERROR, missing implementation error handling';
    END;

    -- Überprüfen, ob die Anfrage erfolgreich war
    IF _content IS NOT NULL AND status = 200 THEN

        -- abgerufene Events in Kalender schreiben
        FOR _event IN SELECT jsonb_array_elements(_content) LOOP
            _ft_name_v      := _event -> 'name' -> 0 ->> 'text';
            _ft_startDate_v := _event ->> 'startDate';
            _ft_endDate_v   := _event ->> 'endDate';

            raise notice '_ft_name_v      = %, _ft_startDate_v = %, _ft_endDate_v   = %', _ft_name_v, _ft_startDate_v, _ft_endDate_v;

            IF _typ = 0 THEN
                INSERT INTO feiertag ( ft_bez, ft_date )
                  SELECT _ft_name_v, _ft_startDate_v
                  WHERE NOT EXISTS ( SELECT true FROM feiertag WHERE ft_date = _ft_startDate_v );
            ELSE
                INSERT INTO ferien ( fte_bez, fte_anf, fte_end )
                  SELECT _ft_name_v, _ft_startDate_v, _ft_endDate_v
                  WHERE NOT EXISTS ( SELECT true FROM ferien WHERE fte_anf = _ft_startDate_v );
            END IF;
      END LOOP;

    END IF;

    IF status <> 200 THEN
        RAISE EXCEPTION 'Abfragen der Feiertage fehlgeschlagen! (HTTP ERROR %)', status;
    END IF;
 END $$ LANGUAGE plpgsql;
--